﻿using System;
using System.Configuration;
using System.IO;
using System.Net;
using NUnit.Framework;
using Spring.Context.Support;
using gov.va.med.VBECS.Communication.Server;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.DependencyInjection;

namespace gov.va.med.vbecs.UnitTest.Communication
{
    [TestFixture]
    public class SequentialMessenger
    {
        private static void initialize()
        {
            //Two configuration files are necessary since object in first file should be created and ready for object in the second one.
            var common = @"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFileCommon"));
            var spring = @"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            DiContext.AppContext = new XmlApplicationContext(new[] { common, spring });
        }


        [SetUp]
        protected void SetUp()
        {
            initialize();
        }

        [Test]
        public void Start_Pass()
        {
            //var mockChannel = new EchoChannel() 
        }

        [TearDown]
        protected void TearDown()
        {
            
        }

    }
}
